# 🎭 Emoji Chat - Real-time Web Application

A simple, fun real-time emoji chat application built with Node.js, Express, and Socket.IO.

## Features

- 💬 Real-time emoji messaging
- 👥 User presence tracking (see who's online)
- 🎨 Beautiful gradient UI with smooth animations
- 📱 Responsive design (works on mobile and desktop)
- 🚀 No database required (in-memory storage)
- ✨ 30 different emojis to choose from

## Quick Start

### Prerequisites

- Node.js (v14 or higher)
- npm (comes with Node.js)

### Installation

1. Navigate to the project directory:
```bash
cd "d:\AK\AntiGravity\Realtime Chat"
```

2. Install dependencies:
```bash
npm install
```

3. Start the server:
```bash
npm start
```

4. Open your browser and navigate to:
```
http://localhost:3000
```

### Testing Real-time Chat

To test the real-time functionality:

1. Open the application in your browser
2. Enter a username and join the chat
3. Open another browser tab (or incognito window) and go to the same URL
4. Join with a different username
5. Start sending emojis and watch them appear in real-time across all tabs!

## How It Works

### Backend (server.js)

The server uses **Express** to serve static files and **Socket.IO** for WebSocket communication:

- **User Connection**: When a user joins, their username is stored in a Map with their socket ID
- **Message Broadcasting**: When a user sends an emoji, it's broadcast to all connected clients
- **User Tracking**: The server maintains a count of online users and notifies all clients when someone joins or leaves

### Frontend (app.js)

The client connects to the Socket.IO server and:

- **Sends Events**: `user-join` (when joining) and `send-emoji` (when sending an emoji)
- **Receives Events**: `new-message` (emoji messages), `user-joined`, `user-left`, and `user-count`
- **Auto-scroll**: Automatically scrolls to the latest message for better UX

## Project Structure

```
emoji-chat-app/
├── server.js           # Express + Socket.IO server
├── package.json        # Project dependencies
└── public/
    ├── index.html      # Main HTML structure
    ├── style.css       # Styling and animations
    └── app.js          # Client-side Socket.IO logic
```

## Technologies Used

- **Backend**: Node.js, Express, Socket.IO
- **Frontend**: Vanilla HTML, CSS, JavaScript
- **Real-time Communication**: WebSockets via Socket.IO

## Default Port

The application runs on port **3000** by default. You can change this by setting the `PORT` environment variable:

```bash
PORT=8080 npm start
```

## Browser Support

Works on all modern browsers that support WebSockets:
- Chrome
- Firefox
- Safari
- Edge

---

**Enjoy chatting with emojis!** 🎉
