---
description: Guide to deploy the Node.js chat app to cPanel
---

# 🚀 Deploying to cPanel (Node.js)

This guide explains how to deploy your Real-Time Emoji Chat to a cPanel subdomain.

## Prerequisites
- cPanel hosting with **Node.js support** (usually "Setup Node.js App").
- Access to cPanel File Manager or FTP.

## Step 1: Prepare Your Application
1. **Zip your project files**:
   - Select all files in your project folder (`server.js`, `package.json`, `public/` folder).
   - **Exclude** `node_modules` folder (it's too big and will be re-installed on the server).
   - Create a zip archive (e.g., `chat-app.zip`).

## Step 2: Create Subdomain
1. Log in to **cPanel**.
2. Go to **Domains** -> **Create A New Domain** (or **Subdomains**).
3. Enter your subdomain (e.g., `chat.yourdomain.com`).
4. Note the **Document Root** path (e.g., `/home/user/public_html/chat`).

## Step 3: Upload Files
1. Go to **File Manager**.
2. Navigate to the **Document Root** folder you just created.
3. **Upload** your `chat-app.zip` file.
4. **Extract** the zip file.
5. Ensure `server.js` and `package.json` are in the main folder of your subdomain.

## Step 4: Setup Node.js Application
1. In cPanel, find **Software** -> **Setup Node.js App**.
2. Click **Create Application**.
3. Fill in the details:
   - **Node.js Version**: Choose a recent version (e.g., 18.x or 20.x).
   - **Application Mode**: `Production`.
   - **Application Root**: The path to your uploaded files (e.g., `public_html/chat`).
   - **Application URL**: Select your subdomain (`chat.yourdomain.com`).
   - **Application Startup File**: `server.js`.
4. Click **Create**.

## Step 5: Install Dependencies
1. Once the app is created, scroll down to find the **"Run NPM Install"** button.
2. Click **Run NPM Install**.
   - This will read your `package.json` and install `express`, `socket.io`, etc.
   - *Note: If the button fails, you can copy the "Enter to the virtual environment" command, paste it in the cPanel Terminal, and run `npm install` manually.*

## Step 6: Restart and Test
1. Click the **Restart Application** button.
2. Open your subdomain URL (e.g., `http://chat.yourdomain.com`).
3. Your chat app should be live! 🎉

## ⚠️ Important Troubleshooting
- **Port Issue**: You do NOT need to specify a port (like `:3000`) in the URL. cPanel uses Phusion Passenger to route traffic from port 80/443 to your Node.js app automatically.
- **Socket.IO Path**: If connections fail, ensure your client-side `socket = io()` call doesn't have a hardcoded URL. It should be just `io()` to auto-detect the domain.
- **Environment Variables**: If you need to set `PORT`, cPanel handles it. Don't hardcode `3000` in `server.js` (use `process.env.PORT || 3000`, which we already do).
